﻿namespace Hims.Shared.UserModels.Labs
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The lab parameter model.
    /// </summary>
    public class LabParameterModel
    {
        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>		
        public int LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name of the parameter.
        /// </summary>
        /// <value>
        /// The name of the parameter.
        /// </value>
        public string ParameterName { get; set; }

        /// <summary>
        /// Gets or sets the parameter identifier.
        /// </summary>
        /// <value>
        /// The parameter identifier.
        /// </value>
        public string ParameterId { get; set; }

        /// <summary>
        /// Gets or sets the term.
        /// </summary>
        /// <value>
        /// The term.
        /// </value>
        public string Term { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        /// <value>
        /// The display name.
        /// </value>
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the reference output.
        /// </summary>
        /// <value>
        /// The reference output.
        /// </value>
        public string ReferenceOutput { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabParameterModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the parameter group.
        /// </summary>
        /// <value>
        /// The parameter group.
        /// </value>
        public List<LabParameterDetailModel> ParameterGroup { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter method identifier.
        /// </summary>
        /// <value>
        /// The lab parameter method identifier.
        /// </value>
        public int? LabParameterMethodId { get; set; }

        /// <summary>
        /// Gets or sets the name of the method.
        /// </summary>
        /// <value>
        /// The name of the method.
        /// </value>
        public string MethodName { get; set; }

        /// <summary>
        /// Gets or sets the text.
        /// </summary>
        /// <value>
        /// The text.
        /// </value>
        public string Text { get; set; }

        /// <summary>
        /// Gets or sets the machine identifier.
        /// </summary>
        /// <value>
        /// The machine identifier.
        /// </value>
        public int MachineId { get; set; }

        /// <summary>
        /// Gets or sets the name of the machine parameter.
        /// </summary>
        /// <value>
        /// The name of the machine parameter.
        /// </value>
        public string MachineParameterName { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int? RoleId { get; set; }
    }

    /// <summary>
    /// The lab parameter detail model.
    /// </summary>
    public class LabParameterDetailModel
    {
        /// <summary>
        /// Gets or sets the lab parameter detail identifier.
        /// </summary>
        /// <value>
        /// The lab parameter detail identifier.
        /// </value>
        public long LabParameterDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>
        public int LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets from age.
        /// </summary>
        /// <value>
        /// From age.
        /// </value>
        public int? FromAge { get; set; }

        /// <summary>
        /// Gets or sets the type of from age.
        /// </summary>
        /// <value>
        /// The type of from age.
        /// </value>
        public string FromAgeType { get; set; }

        /// <summary>
        /// Converts to age.
        /// </summary>
        /// <value>
        /// To age.
        /// </value>
        public int? ToAge { get; set; }

        /// <summary>
        /// Converts to agetype.
        /// </summary>
        /// <value>
        /// The type of to age.
        /// </value>
        public string ToAgeType { get; set; }

        /// <summary>
        /// Gets or sets the minimum value.
        /// </summary>
        /// <value>
        /// The minimum value.
        /// </value>
        public double? MinValue { get; set; }

        /// <summary>
        /// Gets or sets the maximum value.
        /// </summary>
        /// <value>
        /// The maximum value.
        /// </value>
        public double? MaxValue { get; set; }

        /// <summary>
        /// Gets or sets the minimum critical value.
        /// </summary>
        /// <value>
        /// The minimum critical value.
        /// </value>
        public double? MinCriticalValue { get; set; }

        /// <summary>
        /// Gets or sets the maximum critical value.
        /// </summary>
        /// <value>
        /// The maximum critical value.
        /// </value>
        public double? MaxCriticalValue { get; set; }

        /// <summary>
        /// Gets or sets the unit identifier.
        /// </summary>
        /// <value>
        /// The unit identifier.
        /// </value>
        public int? UnitId { get; set; }

        /// <summary>
        /// Gets or sets the name of the unit.
        /// </summary>
        /// <value>
        /// The name of the unit.
        /// </value>
        public string UnitName { get; set; }

        /// <summary>
        /// Gets or sets the range text.
        /// </summary>
        /// <value>
        /// The range text.
        /// </value>
        public string RangeText { get; set; }
    }
}
