﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The pharmacy bill report model.
    /// </summary>
    public class PharmacyBillReportModel
    {
        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public int PharmacySaleHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime SaleDate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the bill amount.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the bill amount.
        /// </summary>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int categoryId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string? ProductName { get; set; }
        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string? BatchNumber { get; set; }
        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public string? ExpiryDate { get; set; }
        /// <summary>
        /// Gets or sets the current stock.
        /// </summary>
        public string? currentStock { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }
        /// <summary>
        /// Gets or sets the purchase quantity.
        /// </summary>
        public int PurchaseQuantity { get; set; }
        /// <summary>
        /// Gets or sets the avialable quantity.
        /// </summary>
        public int AvialableQuantity { get; set; }
        /// <summary>
        /// Gets or sets the sale quantity.
        /// </summary>
        public int SaleQuantity { get; set; }
        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        public int ReturnQuantity { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the sale return header id.
        /// </summary>
        public int? SaleReturnHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the paid via.
        /// </summary>
        public string? PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the overall taxes.
        /// </summary>
        public double OverallTaxes { get; set; }

        /// <summary>
        /// Gets or sets the retailname.
        /// </summary>
        public string RetailName { get; set; }


        /// <summary>
        /// Gets or sets the cash total.
        /// </summary>
        public double? CashTotal { get; set; }
        
        /// <summary>
        /// Gets or sets the card total.
        /// </summary>
        public double? CardTotal { get; set; }

        /// <summary>
        /// Gets or sets the gross total.
        /// </summary>
        public double? GrossTotal { get; set; }
        
        /// <summary>
        /// Gets or sets the gst total.
        /// </summary>
        public double? GstTotal { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy bill type
        /// </summary>
        public bool? pharmacyBillType { get; set; }
        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string? PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string TypeOfPayment { get; set; }

        /// <summary>
        /// Gets or sets the Paid Amount.
        /// </summary>
        public double? PaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime ReceiptDate { get; set; }
    }
}
