﻿namespace Hims.Shared.UserModels.PharmacyIndent
{
    /// <summary>
    /// The pharmacy department indent detail.
    /// </summary>
    public class PharmacyDepartmentIndentDetailModel
    {
        /// <summary>
        /// Gets or sets the pharmacy department indent detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department indent detail identifier.
        /// </value>
        public long? PharmacyDepartmentIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department indent header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department indent header identifier.
        /// </value>
        public long? PharmacyDepartmentIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is replaced.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is replaced; otherwise, <c>false</c>.
        /// </value>
        public bool IsReplaced { get; set; }

        /// <summary>
        /// Gets or sets the requested quantity.
        /// </summary>
        /// <value>
        /// The requested quantity.
        /// </value>
        public int RequestedQuantity { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the purchase unit.
        /// </summary>
        /// <value>
        /// The name of the purchase unit.
        /// </value>
        public string PurchaseUnitName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sale unit.
        /// </summary>
        /// <value>
        /// The name of the sale unit.
        /// </value>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        /// <value>
        /// The purchase unit qty.
        /// </value>
        public int? PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        /// <value>
        /// The sale unit qty.
        /// </value>
        public int? SaleUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the tax identifier.
        /// </summary>
        /// <value>
        /// The tax identifier.
        /// </value>
        public int? TaxId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is product expire.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is product expire; otherwise, <c>false</c>.
        /// </value>
        public bool? IsProductExpire { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy retail stock identifier.
        /// </value>
        public int? PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the approved quantity.
        /// </summary>
        /// <value>
        /// The approved quantity.
        /// </value>
        public int? ApprovedQuantity { get; set; }
    }
}
