﻿namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics.CodeAnalysis;

    /// <summary>
    /// The Main Stock Model -Indent n Issue to retail Store
    /// </summary>
    public class PharmacyStockDetailModel
    {
        /// <summary>
        /// Gets or sets IndentHeaderId
        /// </summary>
        public int IndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the Indent Detail id.
        /// </summary>
        public int IndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the Retail Pharmacy Id.
        /// </summary>
        public int RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the Retail Name.
        /// </summary>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the Pharmacy Stock Id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the Pharmacy Product Id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the IssueHeaderId.
        /// </summary>
        public int IssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the IssueDetailId.
        /// </summary>
        public int IssueDetailId { get; set; }

        /// <summary>
        /// Gets or sets the IndentDates.
        /// </summary>
        public DateTime IndentDate { get; set; }

        /// <summary>
        /// Gets or sets the IndentQty .
        /// </summary>
        public int IndentQty { get; set; }

        /// <summary>
        /// Gets or sets the RequiredDate.
        /// </summary>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets theIssueDate.
        /// </summary>
        public DateTime IssueDate { get; set; }

        /// <summary>
        /// Gets or sets the IssueQty.
        /// </summary>
        public int IssueQty { get; set; }

        /// <summary>
        /// Gets or sets the ExpiryDate.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the BatchNumber
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the Quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the Quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the Indent by name.
        /// </summary>
        public string IndentByName { get; set; }

        /// <summary>
        /// Gets or sets the Indent  by Role name.
        /// </summary>
        public string IndentByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the Issued by name.
        /// </summary>
        public string IssueByName { get; set; }

        /// <summary>
        /// Gets or sets the Issued by Rolename.
        /// </summary>
        public string IssueByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the AvailableQuantity.
        /// </summary>
        public int AvailableQuantity { get; set; }

        /// <summary>
        /// Gets or sets the WareHouseName.
        /// </summary>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the AvailableQuantity.
        /// </summary>
        public int MovedQuantity { get; set; }

    }


}
