﻿#nullable enable
namespace Hims.Shared.UserModels.Scan.ScanAppointment
{
    using Hims.Shared.UserModels.NurseShift;
    using System;
    using System.Reflection;

    /// <summary>
    /// The reschedule appointment request.
    /// </summary>
    public class RescheduleScanAppointmentRequest
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int BookScanAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentDateModel.
        /// </summary>
        public DateModel AppointmentDateModel { get; set; }

        /// <summary>
        /// Gets or sets the appointment notes.
        /// </summary>
        public string? AppointmentNotes { get; set; }

        /// <summary>
        /// Gets or sets the reschedule reason.
        /// </summary>
        public string? RescheduleReason { get; set; }

        /// <summary>
        /// Gets or sets the cancel reason.
        /// </summary>
        public string? Reason { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public string AppointmentTime { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public string AppointmentEndTime { get; set; } = string.Empty;

        /// <summary>
        /// /Gets or sets the scan machine master id.
        /// </summary>
        public int ScanMachineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the name of the machine.
        /// </summary>
        public string? MachineName { get; set; }

        /// <summary>
        /// Gets or sets the appointment ids.
        /// </summary>
        public string? AppointmentIds { get; set; }

        /// <summary>
        /// Gets or sets the ApptDate.
        /// </summary>
        public string? ApptDate { get; set; }
    }

    public class RescheduleScanAppointmentDetails
    {
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient requisition number.
        /// </summary>
        public string? RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient Mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the scan appointment payment status.
        /// </summary>
        public bool? PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the scan machine name.
        /// </summary>
        public string? MachineName { get; set; }

        /// <summary>
        /// Gets or sets the scan appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the scan appointment time.
        /// </summary>
        public string? AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the scan location identifier.
        /// </summary>
        public int? LocationId { get; set; }


    }
}
