﻿namespace Hims.Shared.UserModels.ServiceOrder.Charge
{
    /// <summary>
    ///   <br />
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public int ChargeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge.
        /// </summary>
        /// <value>
        /// The name of the charge.
        /// </value>
        public string ChargeName { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public decimal Cost { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge group.
        /// </summary>
        /// <value>
        /// The name of the charge group.
        /// </value>
        public string ChargeGroupName { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the repeat type identifier.
        /// </summary>
        /// <value>
        /// The repeat type identifier.
        /// </value>
        public int RepeatTypeId { get; set; }

        /// <summary>
        /// Gets or sets the automatic type identifier.
        /// </summary>
        /// <value>
        /// The automatic type identifier.
        /// </value>
        public int AutomaticTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is special doctor.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is special doctor; otherwise, <c>false</c>.
        /// </value>
        public int? ChargeTypeId { get; set; }
    }
}
