﻿namespace Hims.Domain.Helpers
{
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Http;
    using Shared.Library.MailKit;

    /// <summary>
    /// The FTP Service.
    /// </summary>
    public interface IFtpHelper
    {
        /// <summary>
        ///to get a ftp url..
        /// </summary>
        /// <param name="category">
        /// to get a ftp category type.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string GetFtpUrl(string category);

        /// <summary>
        ///to Fetch Image or Thumbnail Base64.
        /// </summary>
        /// <param name="id">
        /// The  id.
        /// </param>
        /// <param name="url">
        /// The url.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FetchImageBase64(int id, string url);

        /// <summary>
        /// The upload async.
        /// </summary>
        /// <param name="base64Image">
        /// Base64.
        /// </param>
        /// <param name="url">
        /// The ftp url.
        /// </param>
        /// /// <param name="fileName">
        /// The file Name.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string FtpUploadProfileImage(string base64Image,string url, string fileName);

        /// <summary>
        ///to delete a profile image or decument..
        /// </summary>
        /// <param name="url">
        /// The url.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string DeleteFtpFile(string url);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="patientDocumentId">
        /// The Fetches Document Base64.
        /// </param>
        /// /// <param name="url">
        /// The Fetches Document p url.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FetchDocumentBase64(int patientDocumentId, string url);

        /// <summary>
        /// The upload async.
        /// </summary>
        /// <param name="patientId">
        /// The patientId.
        /// </param>
        /// <param name="file">
        /// The file information.
        /// </param>
        /// /// <param name="url">
        /// The ftp url.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FtpUploadDocument(int patientId, IFormFile file, string url);
    }
}