﻿using Hims.Domain.Entities;
using Hims.Shared.EntityModels;
using Hims.Shared.Library.Enums;
using Hims.Shared.Library.Helpers;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    public interface IGeneticSpecialityEncounterService
    {
        /// <summary>
        /// The add genetic speciality encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        public Task<int> AddAsync(GeneticSpecialityEncounterModel model);

        /// <summary>
        /// The update genetic speciality encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        public Task<int> UpdateAsync(GeneticSpecialityEncounterModel model);
        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        public Task<GeneticSpecialityEncounterModel> FindDashboardAsync( GeneticSpecialityEncounterModel model);

        /// <summary>
        /// The update genetic speciality encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        public Task<int> CheckExisted(int appointmentId);

    }
}
