﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.OperationTheater;
    using Hims.Shared.UserModels.PharmacyIndent;

    /// <summary>
    /// The IndentService interface.
    /// </summary>
    public interface IIndentService
    {
        /// <summary>
        /// The create indent request async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateIndentRequestAsync(IndentRequestModel model);

        /// <summary>
        /// The delete indent request async.
        /// </summary>
        /// <param name="indentHeaderId">
        /// The indent header id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> DeleteIndentRequestAsync(int indentHeaderId);


        /// <summary>
        /// The delete indent request async.
        /// </summary>
        /// <param name="indentHeaderId">
        /// The indent header id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IndentFetchModel> FindProductNameAsyn(int indentHeaderId);

        /// <summary>
        /// Fetches the inventory indent asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<OTIndentModel>> FetchInventoryIndentAsync(OTIndentModel model);

        /// <summary>
        /// Fetches the inventory indent detail asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ProductModel>> FetchInventoryIndentDetailAsync(OTIndentModel model);

        /// <summary>
        /// Adds the pharmacy department indent asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<long> AddPharmacyDepartmentIndentAsync(PharmacyDepartmentIndentHeaderModel model);

        /// <summary>
        /// Fetches the pharmacy department indent asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDepartmentIndentHeaderModel>> FetchPharmacyDepartmentIndentAsync(PharmacyDepartmentIndentHeaderModel model);

        /// <summary>
        /// Fetches the indent details asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDepartmentIndentDetailModel>> FetchIndentDetailsAsync(PharmacyDepartmentIndentDetailModel model);

        /// <summary>
        /// Approves the pharmacy department indent asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<long> ApprovePharmacyDepartmentIndentAsync(PharmacyDepartmentIndentHeaderModel model);
    }
}
