﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    using Hims.Shared.UserModels;

    /// <summary>
    /// The discount management service interface.
    /// </summary>
    public interface IReferenceTypesServices
    {
       // FetchModules UpdateModule         DeleteModule AddModule

        /// <summary>
        /// The add  module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> AddReference(ReferenceTypeModel model);

        /// <summary>
        /// The update  module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        /// 
        Task<int> UpdateReference(ReferenceTypeModel model);

        /// <summary>
        /// The fetch all  modules async.
        /// </summary>      
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<ReferenceTypeModel>> FetchReferences(ReferenceTypeModel model);
       
        /// <summary>
        /// The delete  module.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> DeleteReferences(ReferenceTypeModel model);
    }
}
