﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// the user service interface
    /// </summary>
    public interface IUserService
    {
        /// <summary>
        /// The get user async.
        /// </summary>
        /// <param name="userId">
        /// The user id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<UserModel> FindAsync(int userId);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<UserModel>> FetchAsync(UserFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<Tuple<int, Guid?>> AddAsync(UserModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(UserModel model);

        /// <summary>
        /// The update image URLs async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <param name="guid">
        /// The GUID.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateImageUrlsAsync(UserModel model, Guid guid);

        /// <summary>
        /// The modify status async.
        /// </summary>
        /// <param name="userId">
        /// The user id.
        /// </param>
        /// <param name="status">
        /// The status.
        /// </param>
        /// <param name="modifiedBy">
        /// The modified By.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(int userId, bool status, int modifiedBy);

        /// <summary>
        /// The locked status async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> LockedStatusAsync(UserModel model);

        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="userId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindFullNameByUserId(int userId);

        /// <summary>
        /// The add ftp async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<Tuple<int, int, Guid?>> AddFtpAsync(UserModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<UserModel>> FetchAllAsync(UserFilterModel model);

    }
}
