﻿namespace Hims.Infrastructure.Configurations.Middleware
{
    using Configurations;
    using Domain.Configurations;
    using Microsoft.Extensions.Configuration;
    using Microsoft.Extensions.DependencyInjection;

    /// <summary>
    /// The configuration options.
    /// </summary>
    public static class ConfigurationMiddleware
    {
        /// <summary>
        /// Configures the service.
        /// </summary>
        /// <param name="services">The services.</param>
        /// <param name="configuration">The configuration.</param>
        public static void ConfigureServices(IServiceCollection services, IConfiguration configuration)
        {
            services.AddSingleton(configuration);

            services.AddSingleton<IEmailConfiguration>(configuration.GetSection($"EmailConfiguration").Get<EmailConfiguration>());
            services.AddSingleton<IKeyVaultConfiguration>(configuration.GetSection($"KeyVaultConfiguration").Get<KeyVaultConfiguration>());
            services.AddSingleton<IIdentityServerConfiguration>(configuration.GetSection($"IdentityServerConfiguration").Get<IdentityServerConfiguration>());
            services.AddSingleton<IApplicationConfiguration>(configuration.GetSection($"ApplicationConfiguration").Get<ApplicationConfiguration>());
             services.AddSingleton<IAmazonS3Configuration>(configuration.GetSection($"AmazonS3Configuration").Get<AmazonS3Configuration>());
            // services.AddSingleton<IFtpConfiguration>(configuration.GetSection($"FtpConfiguration").Get<FtpConfiguration>());
            services.AddSingleton<INewFtpConfiguration>(configuration.GetSection($"NewFtpConfiguration").Get<NewFtpConfiguration>());
            services.AddSingleton<IFCMConfiguration>(configuration.GetSection($"FCMConfiguration").Get<FCMConfiguration>());
            services.AddSingleton<INotificationConfiguration>(configuration.GetSection($"FcmNotification").Get<NotificationConfiguration>());
             services.AddSingleton<IPayUConfiguration>(configuration.GetSection($"PayUConfiguration").Get<PayUConfiguration>());
             services.AddSingleton<IEmailConfigurationLanding>(configuration.GetSection($"EmailConfigurationLanding").Get<EmailConfigurationLanding>());
            services.AddSingleton<IRunningEnvironment>(configuration.GetSection($"RunningEnvironment").Get<RunningEnvironmentConfiguration>());
            services.AddSingleton<ISalucroConfiguration>(configuration.GetSection($"SalucroConfiguration").Get<SalucroConfiguration>());
            services.AddSingleton<IPracticeDetailConfiguration>(configuration.GetSection($"PracticeDetailConfiguration").Get<PracticeDetailConfiguration>());
        }
    }
}
