﻿using System;

namespace Hims.Shared.UserModels.ProviderLeave
{
    /// <summary>
    /// The visit type filter model.
    /// </summary>
    public class UpdateModel
    {
        /// <summary>
        /// Gets or sets the provider leave id.
        /// </summary>
        public long ProviderLeaveId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the leave date.
        /// </summary>
        public DateTime LeaveDate { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the leave dates.
        /// </summary>
        public string LeaveDates { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or Sets the modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LeaveLocationId { get; set; }

        /// <summary>
        /// Get or sets the leave from date.
        /// </summary>
        public string? LeaveFromDate { get; set; }

        /// <summary>
        /// Gets or sets the provider leave end time.
        /// </summary>
        public string? ProviderLeaveEndTime { get; set; }

        /// <summary>
        /// Gets or sets the provider leave start time.
        /// </summary>
        public string? ProviderLeaveStartTime { get; set; }
    }
}
