﻿namespace Hims.Domain.Entities.Inventory
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The inventory department user.
    /// </summary>
    public class InventoryDepartmentUser
    {

        /// <summary>
        /// Gets or sets the inventory department user identifier.
        /// </summary>
        /// <value>
        /// The inventory department user identifier.
        /// </value>
        [Key, Identity]
        public int InventoryDepartmentUserId { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int InventoryDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the account identifier.
        /// </summary>
        /// <value>
        /// The account identifier.
        /// </value>
        public int AccountId { get; set; }
    }
}
