﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The Menu Access.
    /// </summary>
    public class MenuAccess
    {
        /// <summary>
        /// Gets or sets the menu access identifier.
        /// </summary>
        /// <value>
        /// The menu access identifier.
        /// </value>
        [Key, Identity]
        public int MenuAccessId { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is full access.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is full access; otherwise, <c>false</c>.
        /// </value>
        public bool IsFullAccess { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [initial route menu identifier].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [initial route menu identifier]; otherwise, <c>false</c>.
        /// </value>
        public int? InitialRouteMenuId { get; set; }      
       
    }
}
