﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The Payment Initiation Log.
    /// </summary>
    public class PaymentResponseLog
    {
        /// <summary>
        /// Gets or sets the Payment Initiation Log id.
        /// </summary>
        [Key, Identity]
        public int PaymentResponseLogId { get; set; }

        /// <summary>
        /// Gets or sets the json data.
        /// </summary>
        public string JsonData { get; set; }

        /// <summary>
        /// Gets or sets the is success.
        /// </summary>
        public bool IsSuccess { get; set; }

        /// <summary>
        /// Gets or sets the exception.
        /// </summary>
        public string Exception { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
    }
}
