﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities.PediatricGraph
{
    /// <summary>
    /// The pediatric chart type.
    /// </summary>
    public class PediatricChartType
    {
        /// <summary>
        /// Gets or sets the pediatric chart type identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart type identifier.
        /// </value>
        [Key,Identity]
        public int PediatricChartTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="PediatricChartType"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
    }
}
