﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The pharmacy departmental stock.
    /// </summary>
    public class PharmacyDepartmentalStock
    {
        /// <summary>
        /// Gets or sets the pharmacy departmental stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy departmental stock identifier.
        /// </value>
        [Key,Identity]
        public int PharmacyDepartmentalStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy stock identifier.
        /// </value>
        public int? PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy retail stock identifier.
        /// </value>
        public int? PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the tax identifier.
        /// </summary>
        /// <value>
        /// The tax identifier.
        /// </value>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        /// <value>
        /// The quantity in.
        /// </value>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        /// <value>
        /// The quantity out.
        /// </value>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department identifier.
        /// </value>
        public int? PharmacyDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        /// <value>
        /// The barcode.
        /// </value>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }

    }
}
