﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacy indent detail.
    /// </summary>
    public class PharmacyIndentDetail
    {
        /// <summary>
        /// Gets or sets the pharmacy indent detail id.
        /// </summary>
        [Key, Identity]
        public int PharmacyIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent header id.
        /// </summary>
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>

        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>

        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>

        public DateTime? RequestedDate { get; set; }
    }
}
