﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacy purchase header.
    /// </summary>
    public class PharmacyPurchaseHeader
    {
        /// <summary>
        /// Gets or sets the pharmacy purchase header id.
        /// </summary>
        [Key, Identity]
        public int PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        public DateTime? DueDate { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the bill amount.
        /// </summary>
        public double BillAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double Discount { get; set; }

        /// <summary>
        /// Gets or sets the taxes.
        /// </summary>
        public double Taxes { get; set; }

        /// <summary>
        /// Gets or sets the netamount.
        /// </summary>
        public double Netamount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the auto generate bill number.
        /// </summary>
        public string AutoGenerateBillNumber { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the PaymentNumber.
        /// </summary>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the purchase order header identifier.
        /// </summary>
        /// <value>
        /// The purchase order header identifier.
        /// </value>
        public long? PurchaseOrderHeaderId { get; set; }

        public bool? IsCreditClear { get; set; }

        public DateTime? PaidOnDate { get; set; }
    }
}
