﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Shared.Dapper.Attributes;

    /// <summary>
    /// The refund.
    /// </summary>
    public class Refund
    {
        /// <summary>
        /// Gets or sets the refund id.
        /// </summary>
        [Key, Identity]
        public int RefundId { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTransaction id.
        /// </summary>
        public int AppointmentTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the Refund Amount id.
        /// </summary>
        public long RefundAmount { get; set; }

        /// <summary>
        /// Gets or sets the Refund Status.
        /// </summary>
        public int RefundStatus { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the Refund completed Date.
        /// </summary>
        public DateTime? RefundCompletedDate { get; set; }

        /// <summary>
        /// Gets or sets the Refund transaction id.
        /// </summary>
        public int RefundTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
