﻿namespace Hims.Domain.Entities.Vendors
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The component.
    /// </summary>
    [Table("PharmacyProductRequest", Schema = "vendors")]
    public class PharmacyProductRequest
    {
        /// <summary>
        /// Gets or sets the pharmacy product request identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product request identifier.
        /// </value>
        [Key, Identity]
        public long PharmacyProductRequestId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }
       
        /// <summary>
        /// Gets or sets the pharmacy warehouse identifier.
        /// </summary>
        /// <value>
        /// The pharmacy stock identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }
        
        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }
        /// <summary>
        /// Gets or sets the raised by.
        /// </summary>
        /// <value>
        /// The raised by.
        /// </value>
        public int RaisedBy { get; set; }
        /// <summary>
        /// Gets or sets the raised date.
        /// </summary>
        /// <value>
        /// The raised date.
        /// </value>
        public DateTime RaisedDate { get; set; }
        /// <summary>
        /// Gets or sets the approved by.
        /// </summary>
        /// <value>
        /// The approved by.
        /// </value>
        public int? ApprovedBy { get; set; }
        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        /// <value>
        /// The approved date.
        /// </value>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the approval given by.
        /// </summary>
        /// <value>
        /// The approval given by.
        /// </value>
        public int? ApprovalGivenBy { get; set; }

        /// <summary>
        /// Gets or sets the approval given date.
        /// </summary>
        /// <value>
        /// The approved date.
        /// </value>
        public DateTime? ApprovalGivenDate { get; set; }

        /// <summary>
        /// Gets or sets the requested quantity.
        /// </summary>
        /// <value>
        /// The requested quantity.
        /// </value>
        public int? RequestedQuantity { get; set; }
    }
}
