﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary>
    /// The birth certificate Service interface.
    /// </summary>
    public interface IBirthCertificateService
    {
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(BirthCertificateModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<BirthCertificateModel>> FetchAllAsync(BirthCertificateModel model);
        Task<BirthCertificateModel> FetchBirthReportAsync(BirthCertificateModel model);
    }
}
