﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.Library;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Common;
    using Shared.EntityModels;

    /// <summary>
    /// The Appointment Service interface.
    /// </summary>
    public interface ICubicleService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<CubicleModel>> FetchAsync(CubicleFilterModel model);

        Task<Resource> AssignConsultantDoctorAsync(CubicleModel model);
        Task<int> UnAssignConsultantDoctorAsync(CubicleModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<GenericResponse> InsertAsync(CubicleModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<GenericResponse> UpdateAsync(CubicleModel model);

        /// <summary>
        /// Assigns the  asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AssignAsync(CubicleModel model);

        /// <summary>
        /// unassign asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UnassignAsync(CubicleModel model);
        /// <summary>
        /// Deactivates the widget asynchronous.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpadteStatusAsync(int id, int accountStatusId, int modifiedBy);


        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="cubicleId">
        /// The specialization id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int cubicleId);
    }
}
