﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// the practice service interface
    /// </summary>
    public interface IPracticeService
    {
        /// <summary>
        /// The create async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateAsync(PracticeModel model);

        /// <summary>
        /// The approve async.
        /// </summary>
        /// <param name="practiceId">
        /// The practice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<AccountModel> ApproveAsync(int practiceId);

        /// <summary>
        /// The reject async.
        /// </summary>
        /// <param name="practiceId">
        /// The practice id.
        /// </param>
        /// <param name="rejectedComments">
        /// The rejected comments.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> RejectAsync(int practiceId, string rejectedComments);

        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="practiceId">
        /// The practice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<PracticeModel> FindAsync(int practiceId);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PracticeLocationModel>> FetchAsync(PracticeFilterModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(PracticeModel model);

        /// <summary>
        /// Fetches the only practice information.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PracticeLocationModel>> FetchOnlyPracticeInfo(PracticeFilterModel model);
    }
}