﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.ProgressReport.Diet;
    using MedicationInfo = Shared.UserModels.ProgressReport.MedicationInfo;
    using Labs = Shared.UserModels.ProgressReport.Labs;
    using Resource = Hims.Shared.UserModels.VitalType;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IProgressReportDietService
    {

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> StopDietAsync(StopModel model);
    }
}
