﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels;

    /// <summary>
    /// The salutation Service interface.
    /// </summary>
    public interface ISalutationService
    {
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(SalutationModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<SalutationModel>> FetchAllAsync(SalutationModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<SalutationModel>> FetchActiveAllAsync(SalutationModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(SalutationModel model);

        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateTest(SalutationModel model);
    }
}
