﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;

    /// <summary>
    /// The VideoCallHistoryService interface.
    /// </summary>
    public interface IVideoCallHistoryService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<VideoCallHistoryModel>> FetchAsync(int appointmentId);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <param name="doctorDeviceDetailsId">
        /// The doctor device details id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<VideoCallHistoryInfo> FetchAsync(int appointmentId, int doctorDeviceDetailsId);

        /// <summary>
        /// The insert async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> InsertAsync(int appointmentId);
    }
}