﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.UserModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class AuthorityMasterService: IAuthorityMasterService
    {

        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IReasonsService" />
        public AuthorityMasterService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<int> ActivateOrDeactivateTest(AuthorityMasterModel model)
        {
            var query = $@"UPDATE ""AuthorityMaster""
	                           SET ""ModifiedBy""={model.CreatedBy}, ""ModifiedDate""=now(), ""Active""= {model.Active}
	                           WHERE ""AuthorityMasterId""= {model.AuthorityMasterId}";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }

        /// <inheritdoc/>
        public async Task<int> DeleteAsync(AuthorityMasterModel model)
        {
            var query = $@"DELETE FROM ""AuthorityMaster"" WHERE ""AuthorityMasterId"" = {model.AuthorityMasterId}";
            var result = await this.unitOfWork.Current.ExecuteAsync(query);
            return result;
        }

        /// <inheritdoc/>
        public async Task<IEnumerable<AuthorityMasterModel>> FetchAllAsync(AuthorityMasterModel model)
        {

            var query =
                $@"select count(AM.""AuthorityMasterId"") over() as ""TotalItems"", AM.""AuthorityMasterId"", AM.""Authority"", AM.""Active"", AM.""CreatedBy"", AM.""CreatedDate"",
		                        AM.""ModifiedBy"", AM.""ModifiedDate"",
		                        C.""FullName"" as ""CreatedByName"", M.""FullName"" as ""ModifiedByName""
                             FROM ""AuthorityMaster"" AM
                             join ""Account"" C on C.""AccountId"" = AM.""CreatedBy""
                             left join ""Account"" M on M.""AccountId"" = AM.""ModifiedBy""
                             order by AM.""CreatedDate"" desc";



            return await this.unitOfWork.Current.QueryAsync<AuthorityMasterModel>(query);

        }



        /// <inheritdoc/>
        public async Task<int> InsertAsync(AuthorityMasterModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""AuthorityMaster"" where  lower(""Authority"") = '{model.Authority.ToLower()}'");
            if (checkIf > 0)
            {
                return -1;
            }
            var authority = new AuthorityMaster
            {
                Authority = model.Authority,
                CreatedBy = model.CreatedBy,
                Active = true,
                CreatedDate = DateTime.Now,
            };
            return await this.unitOfWork.AuthorityMaster.InsertAsync(authority);
        }

        /// <inheritdoc/>
        public async Task<int> UpdateAsync(AuthorityMasterModel model)
        {

            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""AuthorityMaster"" where  lower (""Authority"") = '{model.Authority.ToLower()}' and ""AuthorityMasterId"" <> {model.AuthorityMasterId}");
            if (checkIf > 0)
            {
                return -1;
            }
            var record = await this.unitOfWork.AuthorityMaster.FindAsync(m => m.AuthorityMasterId == model.AuthorityMasterId);
            if (record == null)
            {
                return -2;
            }
            record.ModifiedBy = model.CreatedBy;
            record.ModifiedDate = DateTime.Now;
            record.Authority = model.Authority;
            return await this.unitOfWork.AuthorityMaster.UpdateAsync(record);



        }
    }
}
