﻿namespace Hims.Infrastructure.Services
{
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.EntityModels;
    using Shared.UserModels.ProviderScheduleCharges;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;

    /// <inheritdoc />
    public class ProviderSchduleChargesService : IProviderScheduleChargesService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IProviderScheduleChargesService" />
        public ProviderSchduleChargesService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public async Task<Tuple<IEnumerable<ViewModel>, IEnumerable<ChargeTypeViewModel>>> FetchAsync(FilterModel model)
        {
            var where = " WHERE 1 = 1 ";
            List<ViewModel> providerAvailabilitySlot = new List<ViewModel>();
            //var  = new IEnumerable<ViewModel>();
            //Collection<ViewModel> providerAvailabilitySlot = new Collection<ViewModel>();


            if (model.FromDate != null)
            {
                // where += $@" and ( PAS.""StartDate""::date >= '{model.FromDate}') ";
                where += $@" and  '{model.FromDate}' <=  PAS.""StartDate""::date ";
            }
            if (model.ToDate != null)
            {
                // where += $@" and  PAS.""EndDate""::date <= '{model.ToDate}' ";
                //where += $@" or  (PAS.""EndDate""::date BETWEEN '{model.FromDate}' AND '{model.ToDate}'))";
                // where += $@" and  PAS.""EndDate""::date >= '{model.ToDate}' ";
                where += $@" and  '{model.ToDate}' >=  PAS.""StartDate""::date ";
            }
            if ((model.FromDate != null) && (model.ToDate != null))
            {
                where = " WHERE 1 = 1 ";
                where += $@" and  (('{model.FromDate}' BETWEEN  PAS.""StartDate""::date AND PAS.""EndDate""::date OR  '{model.ToDate}' BETWEEN  PAS.""StartDate""::date AND PAS.""EndDate""::date)";
                where += $@" or (PAS.""StartDate""::date >= '{model.FromDate}' and PAS.""EndDate""::date <= '{model.ToDate}'))";
            }
            var whereChargeType = " WHERE 1 = 1 ";
            if (model.LocationId != null)
            {
                where += $@" AND PAS.""LocationId"" = {model.LocationId}";
            }
            if ((model.ProviderId != null) && (model.ProviderId != 0))
            {
                where += $@" AND PAS.""ProviderId"" = {model.ProviderId}";
            }
            if ((model.SpecializationId != null) && (model.SpecializationId != 0))
            {
                where += $@" AND PAS.""SpecializationId"" = {model.SpecializationId}";
            }
            if (model.ConsultationTypeId != null)
            {
                where += $@" and PAS.""ConsultationTypeId"" =  {model.ConsultationTypeId}";
            }
            if (model.Active == true)
            {
                where += $@" AND PAS.""Active"" is true";
            }
            else
            {
                where += $@" AND PAS.""Active"" is false";

            }
            var query = $@"Select distinct COUNT(*) OVER () AS ""TotalItems"",string_agg(PAS.""ProviderAvailabilityChargeTypeId""::text,',') as ""SchedulerTypeId"",PAS.""CreatedDate""::date,PAS.""ModifiedDate""::date,PAS.""Active"",sp.""SpecializationName"",p.""FullName"" as ""ProviderName"",c.""ConsultationTypeId"",c.""Name"" as ""ConsultationName"",PAS.""PartsOfDayId"",PAS.""StartDate""::date,PAS.""EndDate""::date,PAS.""SpecializationId"",PAS.""ProviderId"",string_agg(PAS.""ChargeTypesId""::text, ', ') as ""ChargeTypesIds"",
                            string_agg(ct.""ChargeName""::text,',')as ""ChargeNames"",L.""Name""as ""LocationName"",
							PAS.""CreatedBy"",ac.""FullName"" as ""CreatedByName"",PAS.""ModifiedBy"",cc.""FullName"" as ""ModifiedByName"",  PAS.""FollowUpDays"", PAS.""FollowUpDaysLimit""
                                    from ""ProviderAvailabilityChargeType"" PAS
									 join ""Account"" ac on ac.""AccountId"" = PAS.""CreatedBy""
									left join ""Account"" cc on cc.""AccountId"" = PAS.""ModifiedBy""
                                    left join ""Provider"" p on p.""ProviderId"" = PAS.""ProviderId""
                                     join ""ChargeTypes"" ct on ct.""ChargeTypesId""= PAS.""ChargeTypesId""
                                    left join ""Specialization"" sp on sp.""SpecializationId""=PAS.""SpecializationId""
                                    join ""ConsultationType"" c on c.""ConsultationTypeId"" = PAS.""ConsultationTypeId""
                                    join ""Location"" L on L.""LocationId"" = PAS.""LocationId""
                                        {where}
									group by PAS.""CreatedDate""::date,PAS.""ModifiedDate""::date,PAS.""Active"",sp.""SpecializationName"",p.""FullName"",c.""ConsultationTypeId"",c.""Name"",PAS.""PartsOfDayId"",PAS.""StartDate"",PAS.""EndDate"",PAS.""PartsOfDayId"",PAS.""SpecializationId"",PAS.""ProviderId"",L.""Name"",
									PAS.""CreatedBy"",ac.""FullName"",PAS.""ModifiedBy"",cc.""FullName"",  PAS.""FollowUpDays"", PAS.""FollowUpDaysLimit""
                                     order by ""CreatedDate"" desc";

            if (model.PageIndex <= 0)
            {
                _ = await this.unitOfWork.Current.QueryAsync<ViewModel>(query);
            }
            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            providerAvailabilitySlot = (List<ViewModel>)await this.unitOfWork.Current.QueryAsync<ViewModel>(query);
            if (providerAvailabilitySlot.ToList().Count != 0)
            {
                whereChargeType += $@"";
            }
            else
            {
                whereChargeType += $@"";
            }
            query = $@"";


            var availabilityChargeType = await this.unitOfWork.Current.QueryAsync<ChargeTypeViewModel>(query);
            return new Tuple<IEnumerable<ViewModel>, IEnumerable<ChargeTypeViewModel>>(providerAvailabilitySlot, availabilityChargeType);
        }


        /// <inheritdoc />
        public async Task<int> AddAsync(InsertModel model)
        {
            try
            {
                var wh = $@"where 1=1 ";
                if (model.ProviderId != null)
                {
                    wh += $@" AND PAS.""ProviderId"" = {model.ProviderId}";
                }
                else
                {
                    wh += $@" and PAS.""ProviderId"" IS NULL";
                }
                if (model.SpecializationId != null)
                {
                    wh += $@" AND PAS.""SpecializationId"" = {model.SpecializationId}";
                }
                else
                {
                    wh += $@" and PAS.""SpecializationId"" IS NULL";
                }
                if (model.StartDate != null)
                {

                    wh += $@" and  (('{model.StartDate}' BETWEEN  PAS.""StartDate""::date AND PAS.""EndDate""::date";
                }
                if (model.EndDate != null)
                {
                    wh += $@" OR  '{model.EndDate}'::date BETWEEN  PAS.""StartDate""::date AND PAS.""EndDate""::date)";
                }
                if ((model.StartDate != null) && (model.EndDate != null))
                {
                    wh += $@" or (PAS.""StartDate""::date >= '{model.StartDate}'::date and PAS.""EndDate""::date <= '{model.EndDate}'::date))";
                }
                if (model.LocationId != null)
                {
                    wh += $@" AND PAS.""LocationId"" = {model.LocationId}";
                }
                if (model.ConsultationTypeId != null)
                {
                    wh += $@" and PAS.""ConsultationTypeId"" =  {model.ConsultationTypeId}";
                }
                var query = $@"select Count(*) from ""ProviderAvailabilityChargeType"" PAS {wh}";
                var exist = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>(query);
                //var find = await this.unitOfWork.ProviderAvailabilityChargeType.FindAsync(x => x.StartDate == model.StartDate && x.EndDate == model.EndDate && x.ProviderId == model.ProviderId && x.SpecializationId == model.SpecializationId && x.ConsultationTypeId == model.ConsultationTypeId && x.LocationId == model.LocationId);

                //var where = $@"where 1=1 ";
                //if (model.ProviderId != null)
                //{
                //    where += $@" and ""ProviderId"" = {model.ProviderId}";
                //}
                //if (model.SpecializationId != null)
                //{
                //    where += $@" and ""SpecializationId"" = {model.SpecializationId}";
                //}
                //if (model.LocationId != null)
                //{
                //    where += $@" and ""LocationId"" = {model.LocationId}";
                //}
                //if (model.ProviderId == null)
                //{
                //    where += $@" and ""ProviderId"" is null ";
                //}
                //if (model.SpecializationId == null)
                //{
                //    where += $@" and ""SpecializationId"" is null";
                //}

                //var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(*) FROM ""ProviderAvailabilityChargeType"" {where} and ""StartDate"" <= '{model.StartDate}' and ""EndDate"" >='{model.EndDate}' and ""ConsultationTypeId"" = {model.ConsultationTypeId}");
                //if (checkIf > 0)
                //{
                //    return -1;
                //}
                if (exist > 0)
                {
                    return -2;

                }

                var cheking = model.Charges.Find(t => t.ProviderAvailabilityChargeTypeId != 0);

                if (cheking == null)
                {
                    //Provider Availability charges
                    foreach (var charge in model.Charges)
                    {
                        var providerAvailabilityChargeType = new ProviderAvailabilityChargeType
                        {
                            CreatedBy = model.CreatedBy,
                            CreatedDate = DateTime.Now,
                            Active = true,
                            ChargeTypesId = charge.Id,
                            Charge = charge.Value,
                            ProviderId = model.ProviderId,
                            LocationId = model.LocationId,
                            StartDate = Convert.ToDateTime(model.StartDate),
                            EndDate = Convert.ToDateTime(model.EndDate),
                            SpecializationId = model.SpecializationId,
                            ConsultationTypeId = model.ConsultationTypeId,
                            PartsOfDayId = model.PartsOfDayId,
                            FollowUpDays = model.FollowUpDays,
                            FollowUpDaysLimit = model.FollowUpDaysLimit
                        };
                        var insertExecute = await this.unitOfWork.ProviderAvailabilityChargeType.InsertAsync(providerAvailabilityChargeType);

                    }
                }

                return 1;
            }
            catch (Exception e)
            {
                return 0;
            }
        }

        /// <inheritdoc />
        public async Task<int> UpdateAsync(VisitTypeModel model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""VisitTypeId"") FROM ""VisitType"" WHERE TRIM(UPPER(""VisitorName"")) = '{model.VisitorName.ToUpper().Trim()}' AND ""VisitTypeId"" <> {model.VisitTypeId}");
            if (checkIf > 0)
            {
                return -1;
            }

            var visitType = await this.unitOfWork.Visitors.FindAsync(m => m.VisitTypeId == model.VisitTypeId);
            visitType.VisitorName = model.VisitorName;
            visitType.VisitTypeFor = model.VisitTypeFor;
            visitType.Active = true;
            visitType.ModifiedBy = model.ModifiedBy;
            visitType.ModifiedDate = DateTime.Now;
            return await this.unitOfWork.Visitors.UpdateAsync(visitType);
        }

        /// <inheritdoc />
        public Task<int> DeleteAsync(int visitTypeId)
        {
            var query = $@"DELETE FROM ""VisitType"" WHERE ""VisitTypeId""= {visitTypeId}";
            return this.unitOfWork.Current.ExecuteAsync(query);
        }

        public async Task<string> FindNameByVisitorId(int visitTypeId)
        {
            var query = $@"SELECT ""VisitorName"" FROM ""VisitType"" WHERE ""VisitTypeId"" = {visitTypeId}";
            var response = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<string>(query);
            return response;
        }

        public async Task<int> UpdateAsync(InsertModel model)
        {

            using var transaction = this.unitOfWork.BeginTransaction();
            try
            {
                var result = await this.unitOfWork.ProviderAvailabilityChargeType.FindAllAsync();
                var selectedData = result.Where(a => a.ProviderAvailabilityChargeTypeId == model.ProviderAvailabilityChargeTypeId).ToList();
                //var selectedData = result.Where(e => e.StartDate <= model.StartDate && e.EndDate >= model.EndDate && e.LocationId == model.LocationId && e.ProviderId == model.ProviderId && e.SpecializationId == model.SpecializationId && e.ConsultationTypeId == model.ConsultationTypeId).ToList();
                //bool isValid = model.Charges.Any(e => selectedData.Any(a => a.ProviderAvailabilityChargeTypeId == e.ProviderAvailabilityChargeTypeId)) || !selectedData.Any();
                var wh = $@"where 1=1 ";
                if (model.ProviderId != null)
                {
                    wh += $@" AND PAS.""ProviderId"" = {model.ProviderId}";
                }
                else
                {
                    wh += $@" and PAS.""ProviderId"" IS NULL";
                }
                if (model.SpecializationId != null)
                {
                    wh += $@" AND PAS.""SpecializationId"" = {model.SpecializationId}";
                }
                else
                {
                    wh += $@" and PAS.""SpecializationId"" IS NULL";
                }
                if (model.StartDate != null)
                {

                    wh += $@" and  (('{model.StartDate}' BETWEEN  PAS.""StartDate""::date AND PAS.""EndDate""::date";
                }
                if (model.EndDate != null)
                {
                    wh += $@" OR  '{model.EndDate}' BETWEEN  PAS.""StartDate""::date AND PAS.""EndDate""::date)";
                }
                if ((model.StartDate != null) && (model.EndDate != null))
                {
                    wh += $@" or (PAS.""StartDate""::date >= '{model.StartDate}' and PAS.""EndDate""::date <= '{model.EndDate}'))";
                }
                if (model.LocationId != null)
                {
                    wh += $@" AND PAS.""LocationId"" = {model.LocationId}";
                }
                if (model.ConsultationTypeId != null)
                {
                    wh += $@" and PAS.""ConsultationTypeId"" =  {model.ConsultationTypeId}";
                }
                if (selectedData.Count > 0)
                {
                    wh += $@" and (PAS.""StartDate""::date != '{selectedData[0].StartDate}' and PAS.""EndDate""::date != '{selectedData[0].EndDate}')";
                }
                var query = $@"select Count(*) from ""ProviderAvailabilityChargeType"" PAS {wh}";
                var exist = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>(query);
                //if (isValid)
                //{
                if (exist > 0)       // model.Charges.Count
                {
                    return -2;

                }
                //using (var transaction = this.unitOfWork.BeginTransaction())
                //{
                //    int res = 0;
                //    foreach (var charge in model.Charges)
                //    {
                //        var deleteQry = $@"delete  from ""ProviderAvailabilityChargeType"" where ""ProviderAvailabilityChargeTypeId""={charge.ProviderAvailabilityChargeTypeId}";
                //        // var res = this.unitOfWork.Current.ExecuteAsync(deleteQry);

                //        res = await this.unitOfWork.Current.ExecuteAsync(deleteQry, transaction);
                //    }
                //    if (res <= 0)
                //    {
                //        transaction.Rollback();
                //        return -1;
                //    }
                //    else
                //    {
                //        transaction.Commit();
                //        // return res;
                //    }
                //}                
                //var checkquery = $@"select Count(*) from ""ProviderAvailabilityChargeType"" PAS where PAS.""ProviderAvailabilityChargeTypeId""={model.ProviderAvailabilityChargeTypeId}";
                //var existValue = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>(checkquery);
                //if (existValue == 0)
                //{
                //    foreach (var charge in model.Charges)
                //    {
                //        var providerAvailabilityChargeType = new ProviderAvailabilityChargeType
                //        {
                //            CreatedBy = model.CreatedBy,
                //            CreatedDate = DateTime.Now,
                //            ModifiedBy = model.ModifiedBy,
                //            ModifiedDate = DateTime.Now,
                //            Active = true,
                //            ChargeTypesId = charge.Id,
                //            Charge = charge.Value,
                //            ProviderId = model.ProviderId,
                //            LocationId = model.LocationId,
                //            StartDate = Convert.ToDateTime(model.StartDate),
                //            EndDate = Convert.ToDateTime(model.EndDate),
                //            SpecializationId = model.SpecializationId,
                //            ConsultationTypeId = model.ConsultationTypeId,
                //            PartsOfDayId = model.PartsOfDayId
                //        };
                //        var insertExecute = await this.unitOfWork.ProviderAvailabilityChargeType.InsertAsync(providerAvailabilityChargeType);

                //    }
                //}
                var cheking = model.Charges.Find(t => t.ProviderAvailabilityChargeTypeId != 0);


                foreach (var charge in model.Charges)
                {

                    if (charge.ProviderAvailabilityChargeTypeId == 0)
                    {
                        var ProviderAvailabilityChargeTypeInsert = new ProviderAvailabilityChargeType
                        {
                            ModifiedBy = model.ModifiedBy,
                            ModifiedDate = DateTime.Now,
                            Active = true,
                            ChargeTypesId = charge.Id,
                            Charge = charge.Value,
                            ProviderId = model.ProviderId,
                            LocationId = model.LocationId,
                            StartDate = Convert.ToDateTime(model.StartDate),
                            EndDate = Convert.ToDateTime(model.EndDate),
                            SpecializationId = model.SpecializationId,
                            ConsultationTypeId = model.ConsultationTypeId,
                            FollowUpDays = model.FollowUpDays,
                            FollowUpDaysLimit = model.FollowUpDaysLimit
                        };
                        var dataInsert = await this.unitOfWork.ProviderAvailabilityChargeType.InsertAsync(ProviderAvailabilityChargeTypeInsert, transaction);
                        if (dataInsert == 0)
                        {
                            transaction.Rollback();
                            return new int();
                        }
                    }
                    else
                    {
                        var checkIf = await this.unitOfWork.ProviderAvailabilityChargeType.FindAsync(x => x.ProviderAvailabilityChargeTypeId == charge.ProviderAvailabilityChargeTypeId);
                        {
                            checkIf.ChargeTypesId = charge.Id;
                            checkIf.Charge = charge.Value;

                        }
                        var providerAvailabilityChargeType = new ProviderAvailabilityChargeType
                        {
                            ModifiedBy = model.ModifiedBy,
                            ModifiedDate = DateTime.Now,
                            Active = true,
                            ChargeTypesId = checkIf.ChargeTypesId,
                            Charge = checkIf.Charge,
                            ProviderId = model.ProviderId,
                            LocationId = model.LocationId,
                            StartDate = Convert.ToDateTime(model.StartDate),
                            EndDate = Convert.ToDateTime(model.EndDate),
                            SpecializationId = model.SpecializationId,
                            ConsultationTypeId = model.ConsultationTypeId,
                            ProviderAvailabilityChargeTypeId = charge.ProviderAvailabilityChargeTypeId,
                            FollowUpDays = model.FollowUpDays,
                            FollowUpDaysLimit = model.FollowUpDaysLimit
                        };

                        var data = await this.unitOfWork.ProviderAvailabilityChargeType.UpdateAsync(providerAvailabilityChargeType);
                        if (data == 0)
                        {
                            transaction.Rollback();
                            return new int();
                        }
                    }
                }

                transaction.Commit();
                return 1;


            }
            catch (Exception ex)
            {

                transaction.Rollback();
                return -1;
            }
        }

        public async Task<IEnumerable<ViewModel>> FetchDoctorChargeAsync(FilterModel model)
        {
            var where = " WHERE 1 = 1 ";
            var join = "";
            var join1 = "";
            var column = "";
            var column1 = "";
            var groupby = "";
            var groupby1 = "";
            if (model.LocationId != null)
            {
                where += $@" AND PAS.""LocationId"" = {model.LocationId}";
            }
            if (model.ProviderId == null)
            {
                where += $@" and PAS.""ProviderId"" is null ";
            }
            if (model.SpecializationId == null)
            {
                where += $@" and PAS.""SpecializationId"" is null";
            }
            if (model.ProviderId != null)
            {
                //column = $@"p.""FullName"" as ""ProviderName"",";
                //groupby = $@"p.""FullName"",";
                //join += $@"left join ""Provider"" p on p.""ProviderId"" = PAS.""ProviderId""";
                where += $@" AND PAS.""ProviderId"" = {model.ProviderId}";
            }
            if (model.SpecializationId != null)
            {
                //column1 = $@",sp.""SpecializationName""";
                //groupby1 = $@"sp.""SpecializationName"",";
                //join1 += $@"join ""Specialization"" sp on sp.""SpecializationId""=PAS.""SpecializationId""";
                where += $@" AND PAS.""SpecializationId"" = {model.SpecializationId}";
            }


            where += $@" and PAS.""ConsultationTypeId"" = {model.ConsultationTypeId} AND PAS.""Active""= {model.Active} AND PAS.""StartDate"" = '{model.StartDate}' and PAS.""EndDate""='{model.EndDate}'";
            var query = $@"Select distinct COUNT(*) OVER () AS ""TotalItems"",PAS.""LocationId"",c.""ConsultationTypeId"",c.""Name"" as ""ConsultationName"",PAS.""PartsOfDayId"",PAS.""StartDate""::date,PAS.""EndDate""::date,PAS.""ProviderAvailabilityChargeTypeId"", PAS.""SpecializationId"",PAS.""ProviderId"",PAS.""Charge"",PAS.""Charge"" as ""Value"",PAS.""ChargeTypesId"",PAS.""ChargeTypesId"" as ""Id"",
                            ct.""ChargeName"",ct.""ChargeName"" as ""Name"",L.""Name""as ""LocationName"",
							p.""FullName"" as ""ProviderName"",
							PAS.""CreatedBy"",ac.""FullName"" as ""CreatedByName"",PAS.""ModifiedBy"",cc.""FullName"" as ""ModifiedByName"",
				                    sp.""SpecializationName"", PAS.""FollowUpDays"", PAS.""FollowUpDaysLimit""
                                    from ""ProviderAvailabilityChargeType"" PAS
									left join ""Account"" ac on ac.""AccountId"" = PAS.""CreatedBy""
									left join ""Account"" cc on cc.""AccountId"" = PAS.""ModifiedBy""
                                    left join ""ConsultationType"" c on c.""ConsultationTypeId"" = PAS.""ConsultationTypeId""

                                    left join ""Provider"" p on p.""ProviderId"" = PAS.""ProviderId""
                                    left join ""ChargeTypes"" ct on ct.""ChargeTypesId""= PAS.""ChargeTypesId""
                                   
                                    left join ""Specialization"" sp on sp.""SpecializationId""=PAS.""SpecializationId""
                                    join ""Location"" L on L.""LocationId"" = PAS.""LocationId""
                                    {where}
									group by PAS.""LocationId"",c.""ConsultationTypeId"",c.""Name"",PAS.""ProviderAvailabilityChargeTypeId"",PAS.""SpecializationId"",PAS.""ProviderId"",PAS.""Charge"",PAS.""ChargeTypesId"",ct.""ChargeName"",L.""Name"",
p.""FullName"",sp.""SpecializationName"",
									
PAS.""CreatedBy"",ac.""FullName"",PAS.""ModifiedBy"",cc.""FullName""";
            return await this.unitOfWork.Current.QueryAsync<ViewModel>(query);
        }

        public Task<IEnumerable<PartsOfDayModel>> FetchDayPartAsync(PartsOfDayModel model)
        {
            var where = $@" where 1=1";

            var query = $@"SELECT p.""PartsOfDayId"",p.""PartsOfDayName"",p.""Active"",p.""CreatedBy"",p.""CreatedDate"",p.""ModifiedBy"",
                            p.""ModifiedDate""
                            from ""PartsOfDay"" p {where}";
            return this.unitOfWork.Current.QueryAsync<PartsOfDayModel>(query);
        }

        public async Task<int> ModifyStatusAsync(InsertModel model)
        {
            try
            {

                var whereStr = $@"";
                var typeId = model.SchedulerTypeId.Split(',');

                for (var i = 0; i < typeId.Length; i++)
                {
                    whereStr += @$"'{typeId[i]}'";
                    if (i < typeId.Length - 1)
                    {
                        whereStr += $@",";
                    }
                }

                var query = $@"UPDATE ""ProviderAvailabilityChargeType"" SET ""Active"" = {model.Active}, ""ModifiedBy""  = {model.ModifiedBy} , ""ModifiedDate"" = '{DateTime.Now}' WHERE ""ProviderAvailabilityChargeTypeId"" in ({whereStr})";

                var num = await this.unitOfWork.Current.QueryAsync<int>(query);

                return 1;
            }
            catch (Exception e)
            {
                e.Message.ToString();
            }

            return -1;
        }

        public Task<IEnumerable<ViewModel>> FetchProvidersWithSpecializationAsync(int locationId)
        {
            var where = $@" where 1=1";
            if ((locationId != 0) && (locationId != null))
            {
                where += $@" AND prl.""LocationId"" = {locationId}";
            }
            var query = $@"SELECT DISTINCT  prl.""ProviderId"" ,pr2.""FullName"", 
 s. ""SpecializationId"", s.""SpecializationName"", prl.""LocationId""
                           FROM ""ProviderAvailabilityChargeType"" prl
                           JOIN ""Location"" pral on pral.""LocationId"" = prl.""LocationId"" AND pral.""Active"" IS TRUE					   
                         
                           JOIN ""Provider"" pr2 on pr2.""ProviderId"" = prl.""ProviderId"" and pr2.""Active"" is true
						   join ""Specialization"" s on s.""SpecializationId"" = prl.""SpecializationId"" {where}";
            return this.unitOfWork.Current.QueryAsync<ViewModel>(query);
        }
    }
}