﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using Hims.Domain.Entities.Enums;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account.
    /// </summary>
    [Table("InformationLog", Schema = "mobile")]
    public class InformationLog
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        [Key, Identity]
        public int InformationLogId { get; set; }
        public string? Uuid { get; set; }
        public ActionType ActionTypeId { get; set; }
        public int? SupportId { get; set; }
        public string? SupportIdName { get; set; }
        public string? Message { get; set; }
        public DateTime Date { get; set; }
    }
}