﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities.Labs
{
    public class ExternalLabAgencyDetail
    {
        /// <summary>
        /// Gets or sets the external lab agency detail identifier.
        /// </summary>
        /// <value>
        /// The external lab agency detail identifier.
        /// </value>
        [Key, Identity]
        public int ExternalLabAgencyDetailId { get; set; }

        /// <summary>
        /// Gets or sets the external lab agency identifier.
        /// </summary>
        /// <value>
        /// The external lab agency identifier.
        /// </value>
        public int ExternalLabAgencyId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ExternalLabAgencyDetail"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
    }
}
