﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The surgery charge.
    /// </summary>
    public class SurgeryCharge
    {
        /// <summary>
        /// Gets or sets the surgery charge identifier.
        /// </summary>
        /// <value>
        /// The surgery charge identifier.
        /// </value>
        [Key, Identity]
        public int SurgeryChargeId { get; set; }

        /// <summary>
        /// Gets or sets the surgery identifier.
        /// </summary>
        /// <value>
        /// The surgery identifier.
        /// </value>
        public int SurgeryId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge.
        /// </summary>
        /// <value>
        /// The name of the charge.
        /// </value>
        public string ChargeName { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double? Amount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="SurgeryCharge"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
    }
}
