﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.Laboratory;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The laboratory dashboard.
    /// </summary>
    public interface ILaboratoryDashboardService
    {
        /// <summary>
        /// The fetch all labs async.
        /// </summary>
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LabHeaderModel>> FetchLabs();

        /// <summary>
        /// The fetch all labs async.
        /// </summary>
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LabsDashboardRevenueModel>> FetchLabRevenueGraphReport(LabsDashboardModel model);
    }
}
