﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The insurance company filter model.
    /// </summary>
    public class InsuranceCompanyFilterModel
    {
        /// <summary>
        /// Gets or sets the insurance company Id.
        /// </summary>
        public int? InsuranceCompanyId { get; set; }
        /// <summary>
        /// Gets or sets the insurance company name.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the insurance company name.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the contact person name.
        /// </summary>
        public string? ContactPersonName { get; set; }
    }
}
