﻿using Hims.Shared.Dapper.Attributes;
using Hims.Shared.EntityModels;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Diagnostics;
using System.Text;

namespace Hims.Shared.UserModels
{
    public class ReferralFormModel
    {
        /// <summary>
        /// Gets or sets the gyn encounter id.
        /// </summary>
        public int? ReferralFormId { get; set; }
        /// <summary>
        /// Gets or sets provider id.
        /// </summary>
        public string? ReferralDoctor { get; set; }
        /// <summary>
        /// Gets or sets reason.
        /// </summary>
        public string? Reason { get; set; }
        /// <summary>
        /// Gets or sets required date.
        /// </summary>
        public DateTime? RequiredDate { get; set; }
        /// <summary>
        /// Gets or sets time.
        /// </summary>
        public string? Time { get; set; }

        /// <summary>
        /// Gets or sets created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or set consultant doctor.
        /// </summary>
        public string? ConsultantDoctor { get; set; }
        /// <summary>
        /// Gets or sets the opinion.
        /// </summary>
        public string? Opinion { get; set; }
        /// <summary>
        /// Gets or sets active.
        /// </summary>
        public bool? Active { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }
        /// <summary>
        /// Gets or sets encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? ReferralDoctorId { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or sets ASKED BY.
        /// </summary>
        public string? AskedBy { get; set; }
        /// <summary>
        /// Gets or sets patient name
        /// </summary>
        public string? PatientName { get; set; }
        public bool IsAdmission { get; set; }
    }
}
