﻿namespace Hims.Domain.Entities.Inventory
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;


    /// <summary>
    /// The inventory issued stock header.
    /// </summary>
    public class InventoryIssuedStockHeader
    {
        /// <summary>
        /// Gets or sets the inventory issued stock header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issued stock header identifier.
        /// </value>
        [Key, Identity]
        public long InventoryIssuedStockHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the issued date.
        /// </summary>
        /// <value>
        /// The issued date.
        /// </value>
        public DateTime IssuedDate { get; set; }

        /// <summary>
        /// Gets or sets the issued by.
        /// </summary>
        /// <value>
        /// The issued by.
        /// </value>
        public int IssuedBy { get; set; }

        /// <summary>
        /// Gets or sets the issue header identifier.
        /// </summary>
        /// <value>
        /// The issue header identifier.
        /// </value>
        public int IssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the hand over to.
        /// </summary>
        /// <value>
        /// The hand over to.
        /// </value>
        public int? HandOverTo { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int? InventoryDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the received by.
        /// </summary>
        /// <value>
        /// The received by.
        /// </value>
        public int? ReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the received date.
        /// </summary>
        /// <value>
        /// The received date.
        /// </value>
        public DateTime? ReceivedDate { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the issue number.
        /// </summary>
        /// <value>
        /// The issue number.
        /// </value>
        public string IssueNumber { get; set; }
    }
}
