﻿namespace Hims.Domain.Entities
{
    using System;
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab booking detail.
    /// </summary>
    public class LabBookingDetail
    {
        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        [Key, Identity]
        public int LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking header id.
        /// </summary>
        public int LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int? LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab package id.
        /// </summary>
        public int? LabPackageId { get; set; }

        /// <summary>
        /// Gets or sets the lab service identifier.
        /// </summary>
        /// <value>
        /// The lab service identifier.
        /// </value>
        public int? LabServicesId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is report generated.
        /// </summary>
        public bool? IsReportGenerated { get; set; }

        /// <summary>
        /// Gets or sets the report date.
        /// </summary>
        public DateTime? ReportDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is sample collected.
        /// </summary>
        public bool? IsSampleCollected { get; set; }

        /// <summary>
        /// Gets or sets the sample date.
        /// </summary>
        public DateTime? SampleDate { get; set; }

        /// <summary>
        /// Gets or sets the typed by.
        /// </summary>
        public int? TypedBy { get; set; }

        /// <summary>
        /// Gets or sets the typed date.
        /// </summary>
        public DateTime? TypedDate { get; set; }

        /// <summary>
        /// Gets or sets the verified by.
        /// </summary>
        public int? VerifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public int? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the lab date.
        /// </summary>
        /// <value>
        /// The lab date.
        /// </value>
        public DateTime? LabDate { get; set; }

        /// <summary>
        /// Gets or sets the verified by doctor identifier.
        /// </summary>
        /// <value>
        /// The verified by doctor identifier.
        /// </value>
        public int? VerifiedByDoctorId { get; set; }
        /// <summary>
        /// Gets or sets the sample collected by account identifier.
        /// </summary>
        /// <value>
        /// The sample collected by account identifier.
        /// </value>
        public int? SampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the barcode identifier.
        /// </summary>
        /// <value>
        /// The barcode identifier.
        /// </value>

        public bool Barcode { get; set; }

        /// <summary>
        /// Gets or sets the barcode generated by identifier.
        /// </summary>
        /// <value>
        /// The barcode  generated by identifier.
        /// </value>

        public int? BarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the borcode generated date.
        /// </summary>
        /// <value>
        /// The borcode generated date identifier.
        /// </value>

        public DateTime? BarcodeGeneratedDate { get; set; }
    }
}
