﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Patient Document Service interface.
    /// </summary>
    public interface IPatientDocumentService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The filter model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDocumentModel>> FetchAsync(PatientDocumentFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<int>> AddAsync(IEnumerable<PatientDocumentModel> model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(PatientDocumentModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(PatientDocumentModel model);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<DeleteDocumentModel> DeleteAsync(ModifyPatientDocumentModel model);

        /// <summary>
        /// The modify read async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyReadAsync(ModifyPatientDocumentModel model);

        /// <summary>
        /// The get async.
        /// </summary>
        /// <param name="id">
        /// The id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<PatientDocumentModel> GetAsync(int id);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The filter model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDocumentModel>> DownloadFetchFileFTP(PatientDocumentFilterModel model);

        /// <summary>
        /// Gets the patient document on identifier asynchronous.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <returns></returns>
        Task<PatientDocumentModel> GetPatientDocumentOnIdAsync(int id);

        /// <summary>
        /// Gets the patient scan document on identifier asynchronous.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <returns></returns>
        Task<ScanDocumentModel> GetScanDocumentOnIdAsync(int id);
        /// <summary>
        /// Gets the patient scan document on identifier asynchronous.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <returns></returns>
        Task<PackageDocumentModel> GetPackageDocument(int id);
    }
}