﻿import { Directive, HostListener } from "@angular/core";
import { KeyCodesHelper, RegExHelper } from "@shared/helpers";

@Directive({
    selector: "[numbersOnly]"
})
export class NumbersOnlyDirective {
    @HostListener("keydown", ["$event"])
    onKeyDown(e: KeyboardEvent) {
        const keys = KeyCodesHelper.default.concat(KeyCodesHelper.numbers);
        if (keys.indexOf(e.keyCode) === -1) {
            event.preventDefault();
            return;
        }

        if (KeyCodesHelper.specialCharacters.indexOf(e.key) > -1) {
            event.preventDefault();
            return;
        }

        if (KeyCodesHelper.defaultNames.indexOf(e.key) === -1) {
            return;
        }

        if (RegExHelper.numbersOnly.test(e.key))
            return;

        event.preventDefault();
    }
}