﻿import { Injectable } from "@angular/core";
import { HttpService } from "./http.service";
import { ApiResources } from "../helpers";
import { NotifyService } from "./notify.service";
import { MasterBillModel } from "../entities";
import { Router } from "@angular/router";

@Injectable()
export class BillNotificationService {
    masterBill: Array<MasterBillModel>;

    constructor(
        private readonly httpService: HttpService,
        private readonly notifyService: NotifyService,
        private readonly router: Router,

    ) {
        this.masterBill = new Array<MasterBillModel>();
    }
    get(patientId?: number) {
        const request = {
            patientId: patientId
        }
        this.httpService
            .post(ApiResources.getURI(ApiResources.masterbill.base, ApiResources.masterbill.fetchPatientDue), request)
            .subscribe(
                (response: Array<MasterBillModel>) => {
                    this.masterBill = response;
                    if (response && response.length > 0) {
                        this.notifyService.confirm(`You are having Payment Due in <b>${this.masterBill[0].modulesName}</b>, Do you want to pay ?`, () => {
                            this.onPayDue(this.masterBill[0].encryptedPatientId)
                        }, () => { $("#printButton").click(); })
                    }
                },
                () => {
                }
            );
    }
    onPayDue(encryptedPatientId: string) {
        this.router.navigateByUrl(`app/masters/final-master-bill/${encryptedPatientId}`);
    }
}