﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The ReferralDoctor.
    /// </summary>
    public class ReferralDoctorModel
    {
        /// <summary>
        /// Gets or sets the Referral doctor id.
        /// </summary>
        public int ReferralDoctorId { get; set; }

        /// <summary>
        /// Gets or sets the Referral doctor first name.
        /// </summary>
        public string Salutation { get; set; }

        /// <summary>
        /// Gets or sets the Referral doctor first name.
        /// </summary>
        public string FirstName { get; set; }

        /// <summary>
        /// Gets or sets the Referral doctor last name.
        /// </summary>
        public string LastName { get; set; }

        /// <summary>
        /// Gets or sets the Referral doctor Full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the Referral doctor mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the Referral doctor  email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the Referral doctor created name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the Referral doctor modified name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>        
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }   

        

    }
}
