﻿using System;

namespace Hims.Shared.UserModels.BedManagement.Bed
{

    /// <summary>
    /// The common response.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the ward identifier.
        /// </summary>
        /// <value>
        /// The ward identifier.
        /// </value>
        public int BedId { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the bed status identifier.
        /// </summary>
        /// <value>
        /// The bed status identifier.
        /// </value>
        public int BedStatusId { get; set; }

        /// <summary>
        /// Gets or sets the name of the bed status.
        /// </summary>
        /// <value>
        /// The name of the bed status.
        /// </value>
        public string BedStatusName { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail URL.
        /// </summary>
        /// <value>
        /// The thumbnail URL.
        /// </value>
        public string ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the unique identifier.
        /// </summary>
        /// <value>
        /// The unique identifier.
        /// </value>
        public string Guid { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        /// <value>
        /// The admission no.
        /// </value>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the provider.
        /// </summary>
        /// <value>
        /// The name of the provider.
        /// </value>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the provider gender.
        /// </summary>
        /// <value>
        /// The provider gender.
        /// </value>
        public string ProviderGender { get; set; }
    }
}
