﻿namespace Hims.Shared.UserModels.Laboratory
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The lab header model.
    /// </summary>
    public class LabHeaderModel
    {
        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab package detail id.
        /// </summary>
        public int LabPackageDetailId { get; set; }

        /// <summary>
        /// Gets or sets the patient lab detail identifier.
        /// </summary>
        /// <value>
        /// The patient lab detail identifier.
        /// </value>
        public int PatientLabDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab package id.
        /// </summary>
        public int? LabPackageId { get; set; }

        /// <summary>
        /// Gets or sets the lab service identifier.
        /// </summary>
        /// <value>
        /// The lab service identifier.
        /// </value>
        public int? LabServicesId { get; set; }

        /// <summary>
        /// Gets or sets the lab code.
        /// </summary>
        public string LabCode { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string Signature { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string TestParameter { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string[] LabData { get; set; }

        /// <summary>
        /// Gets or sets the unit.
        /// </summary>
        public int Unit { get; set; }

        /// <summary>
        /// Gets or sets the charge.
        /// </summary>
        public double Charge { get; set; }

        /// <summary>
        /// Gets or sets the charge as cost.
        /// </summary>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets the in patient charge.
        /// </summary>
        public double InPatientCharge { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab details.
        /// </summary>
        public List<LabDetailModel> LabDetails { get; set; }

        /// <summary>
        /// Gets or sets the lab details.
        /// </summary>
        public List<LocationLabHeaderMapModel> LabLocChargeDetails { get; set; }

        /// <summary>
        /// Gets or sets the no of parameter.
        /// </summary>
        public int NoOfParameter { get; set; }

        /// <summary>
        /// Gets or sets created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public int? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }
        
        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the lab.
        /// </summary>
        /// <value>
        /// The lab.
        /// </value>
        public DateTime? LabDate { get; set; }

        /// <summary>
        /// Gets or sets the Location Id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the lab department identifier.
        /// </summary>
        /// <value>
        /// The lab department identifier.
        /// </value>
        public int LabDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }
    }
}
