﻿using System.Collections.Generic;

#nullable enable
namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The self registration request.
    /// </summary>
    public class SelfRegistrationModel
    {
        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        public string FriendlyName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        public string ProviderNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Email { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the experience.
        /// </summary>
        public double? Experience { get; set; }

        /// <summary>
        /// Gets or sets the languages.
        /// </summary>
        public string? Languages { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the specializations.
        /// </summary>
        public string? Specializations { get; set; } 

        /// <summary>
        /// Gets or sets the Base64 Profile Image.
        /// </summary>
        public string Base64ProfileImage { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Profile Image url.
        /// </summary>
        public string ProfileImageUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Thumbnail Url.
        /// </summary>
        public string ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether is agreed.
        /// </summary>
        public bool IsAgreed { get; set; }
    }
}
