﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    using Hims.Shared.UserModels.Filters;

    /// <summary>
    /// The generalAdvice Service interface.
    /// </summary>
    public interface IGeneralAdviceService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<GeneralAdviceModel>> FetchAsync(GeneralAdviceFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(GeneralAdviceModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(GeneralAdviceModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="generalAdviceId">
        /// The generalAdvice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int generalAdviceId);

        /// <summary>
        /// The get delete async in provider encounter.
        /// </summary>
        /// <param name="generalAdviceId">
        /// The generalAdvice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> updateProviderEncounterAsync(int generalAdviceId);
    }
}
