﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The video call history model.
    /// </summary>
    public class VideoCallHistoryModel
    {
        /// <summary>
        /// Gets or sets the video call history id.
        /// </summary>
        public int VideoCallHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string? Reason { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time string.
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the doctor full name.
        /// </summary>
        public string? DoctorFullName { get; set; }

        /// <summary>
        /// Gets or sets the patient full name.
        /// </summary>
        public string? PatientFullName { get; set; }

        /// <summary>
        /// Gets or sets the doctor device details id.
        /// </summary>
        public int DoctorDeviceDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the patient device details id.
        /// </summary>
        public int PatientDeviceDetailsId { get; set; }
    }
}