﻿namespace Hims.Shared.UserModels.InPatientsView
{
    public class FetchModel
    {
        public int AdmissionId { get;set; }
        public string FullName { get;set; }
        public string Age { get;set; }
        public string Gender { get;set; }
        public int? MedicationsCount { get; set; }
        public int? NotesCount { get; set; }
        public int? VitalsCount { get; set; }
        public string? NurseAssessment { get; set; }

        public string? EncryptedAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the bed number.
        /// </summary>
        /// <value>
        /// The bed number.
        /// </value>
        public string? BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the room.
        /// </summary>
        /// <value>
        /// The name of the room.
        /// </value>
        public string? RoomName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string? WardName { get; set; }

        /// <summary>
        /// Gets or sets the name of the floor.
        /// </summary>
        /// <value>
        /// The name of the floor.
        /// </value>
        public string? FloorName { get; set; }
    }
}
