﻿namespace Hims.Shared.UserModels.Laboratory
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The add booking.
    /// </summary>
    public class PackageImportModel
    {
        /// <summary>
        /// Gets and sets the lab booking header id.
        /// </summary>
        public int LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the patient lab header identifier.
        /// </summary>
        /// <value>
        /// The patient lab header identifier.
        /// </value>
        public int PatientLabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab package id.
        /// </summary>
        public int LabPackageId { get; set; }

        /// <summary>
        /// Gets or sets patient type.
        /// </summary>
        public string PatientType { get; set; }

        /// <summary>
        /// Gets or sets status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the Mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the paid via.
        /// </summary>
        //public string PaidVia { get; set; } adding paytype id instead.

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the verified by.
        /// </summary>
        public int? VerifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public int? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the labs.
        /// </summary>
        public List<LabHeaderModel> Packages { get; set; }

        /// <summary>
        /// Gets or sets the package name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets package name.
        /// </summary>
        public string PackageName { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets Notes.
        /// </summary>
        public string? Notes { get; set; }

        /// <summary>
        /// Gets or sets the lab Location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the Pay Type id.
        /// </summary>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment /transaction number.
        /// </summary>
        public string PaymentNumber { get; set; }
    }
}
