﻿namespace Hims.Shared.UserModels.PayU
{
    /// <summary>
    /// The web hook.
    /// </summary>
    public class WebHook
    {
        /// <summary>
        /// Gets or sets the event.
        /// </summary>
        public string Event { get; set; }

        /// <summary>
        /// Gets or sets the msg.
        /// </summary>
        public string Msg { get; set; }

        /// <summary>
        /// Gets or sets the current balance.
        /// </summary>
        public string CurrentBalance { get; set; }

        /// <summary>
        /// Gets or sets the alert time.
        /// </summary>
        public string AlertTime { get; set; }

        /// <summary>
        /// Gets or sets the event name.
        /// </summary>
        public string EventName { get; set; }

        /// <summary>
        /// Gets or sets the transfer id.
        /// </summary>
        public string TransferId { get; set; }

        /// <summary>
        /// Gets or sets the reference id.
        /// </summary>
        public string ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the payout merchant id.
        /// </summary>
        public string PayoutMerchantId { get; set; }

        /// <summary>
        /// Gets or sets the payu ref id.
        /// </summary>
        public string PayuRefId { get; set; }

        /// <summary>
        /// Gets or sets the merchant reference id.
        /// </summary>
        public string MerchantReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the bank reference id.
        /// </summary>
        public string BankReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the error code.
        /// </summary>
        public string ErrorCode { get; set; }

        /// <summary>
        /// Gets or sets the merchant misc id.
        /// </summary>
        public string MerchantMiscId { get; set; }

        /// <summary>
        /// Gets or sets the link id.
        /// </summary>
        public string LinkId { get; set; }
    }
}
